=begin

License

Copyright © 2018, Numato Systems Private Limited. All rights reserved.

This software including all supplied files, Intellectual Property, know-how
or part of thereof as applicable (collectively called SOFTWARE) in source
and/or binary form with accompanying documentation is licensed to you by
Numato Systems Private Limited (LICENSOR) subject to the following conditions.

1. This license permits perpetual use of the SOFTWARE if all conditions in this
   license are met. This license stands revoked in the event of breach of any
   of the conditions.    
2. You may use, modify, copy the SOFTWARE within your organization. This
   SOFTWARE shall not be transferred to third parties in any form except
   fully compiled binary form as part of your final application.
3. This SOFTWARE is licensed only to be used in connection with/executed on
   supported products manufactured by Numato Systems Private Limited.
   Using/executing this SOFTWARE on/in connection with custom or third party
   hardware without the LICENSOR's prior written permission is expressly
   prohibited.
4. You may not download or otherwise secure a copy of this SOFTWARE for the
   purpose of competing with Numato Systems Private Limited or subsidiaries in
   any way such as but not limited to sharing the SOFTWARE with competitors, 
   reverse engineering etc... You may not do so even if you have no gain 
   financial or otherwise from such action.
5. DISCLAIMER
5.1. USING THIS SOFTWARE IS VOLUNTARY AND OPTIONAL. NO PART OF THIS SOFTWARE
     CONSTITUTE A PRODUCT OR PART OF PRODUCT SOLD BY THE LICENSOR.
5.2. THIS SOFTWARE AND DOCUMENTATION ARE PROVIDED “AS IS” WITH ALL FAULTS,
     DEFECTS AND ERRORS AND WITHOUT WARRANTY OF ANY KIND.
5.3. THE LICENSOR DISCLAIMS ALL WARRANTIES EITHER EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY OR FITNESS FOR ANY
     PURPOSE.
5.4. IN NO EVENT, SHALL THE LICENSOR, IT’S PARTNERS OR DISTRIBUTORS BE LIABLE OR
     OBLIGATED FOR ANY DAMAGES, EXPENSES, COSTS, LOSS OF MONEY, LOSS OF TANGIBLE
     OR INTANGIBLE ASSETS DIRECT OR INDIRECT UNDER ANY LEGAL ARGUMENT SUCH AS BUT
     NOT LIMITED TO CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH
     OF WARRANTY OR ANY OTHER SIMILAR LEGAL DEFINITION.
     
    Ruby code demonstrating features of Numato Lab 4 Channel 
    USB Relay Module.
    
    Usage: scriptname.pl <PORT>
    E.g.: 4usbrelay.pl COM1 

prerequisites
--------------
install ruby
install rubyserial

=end     

require 'rubyserial'

##########################################################
#               Serial port related methods              #
##########################################################

#Return the response from serialport
def read
    $response = " "
    loop do
        $response += $serport.read(10)
        if $response.match(/>$/)
            break
        end
    end
    return $response
end

##########################################################
#                           Menus                        #
##########################################################

#Display the menu and returns user selection
def getMenuSelection
    puts "\nPlease select from following menu options
    
    1. Get Firmware Version
    2. Get Module ID
    3. Set Module ID
    4. Relay Status and Control
    5. ADC Status
    6. GPIO Status and Control
    7. Reset
    q. Exit"
    print "Enter Selection : "
    return STDIN.gets.chomp
end

#Display the menu and returns user selection
def RelayStatus_Control
    puts "\nPlease select from following menu options
    
    1. Relay Status
    2. Relay Control
    b. Back to main menu
    q. Exit"
    print "Enter Selection : "
    return STDIN.gets.chomp
end

#Display the menu and returns user selection
def relaycontrol
    puts "\nPlease select from following menu options

    1. ON Relay
    2. OFF Relay
    3. Back to previous menu
    b. Back to main menu
    q. Exit"

    print "Enter Selection : "
    return STDIN.gets.chomp
end

#Display the menu and returns user selection
def GPIO
    puts "\nPlease select from following menu options
    
    1. GPIO Status
    2. GPIO Control
    b. Back to main menu
    q. Exit"

    print "Enter Selection : "
    return STDIN.gets.chomp
end

#Display the menu and returns user selection
def gpioControl
    puts "\nPlease select from following menu options: 
    
    1. Set GPIO
    2. Clear GPIO
    3. Back to previous menu
    b. Back to main menu
    q. Exit"
    print "Enter Selection : "
    return STDIN.gets.chomp
end

##########################################################
#             Module related misc. functions             #
##########################################################

#Retrieve and print FW version
def getFWVersion
    puts "\nVersion\n-------" 
    
    #Send ver command. 
    $serport.write("ver\r")

    #Read the response and print the firmware version
    $response = read()
    return $response.split('ver').join(' ').gsub(">"," ")
end
    
#Retrieve and print Module ID    
def getModuleid
    puts "\nModule ID\n---------"
    
    #Get Current Module ID
    $serport.write("id get\r")
    $response = read()
    return $response.split('id get').join(' ').gsub(">"," ")
end

#Sets Module ID
def setModuleid
    #Get new Module ID form user 
    while 1
        print "Enter new ID (8 alphanumeric characters only): "
        id = STDIN.gets.chomp
        if id.length == 8
            break
        end
    end
    #Send Command 
    $serport.write("id set " + id + "\r")
    sleep(1)
    $response = read()
    puts "\n
    --------------------------
    Module ID set successfully
    --------------------------"
end
 
#Resets the device
def reset

    $serport.write("reset\r")
    $response = read()
    return "Reset successfully"
end

##########################################################
#                     Relay operations                   #
##########################################################

#Retrieve and print relay status
def getRelayStatus
    #Get Relay index/number from the user
    while 1
        print "\nEnter Relay Number ( 0 to 3): "
        relay_number = STDIN.gets.chomp
        if (('0'..'3') === relay_number)
            break
        end
    end

    #Send command
    $serport.write("relay read " + relay_number + "\r")
    #Read and process response from the device
    $response = read()
    return $response.split[3], relay_number
end

#Relay ON
def relayOn
    #Get Relay index/number from the user
    while 1
        print "\nEnter Relay Number ( 0 to 3): "
        relay_number = STDIN.gets.chomp
        if (('0'..'3') === relay_number)
            break
        end
    end
    #Send Command
    $serport.write(("relay on " + relay_number + "\r")
    $response = read()
    
end

#Relay OFF
def relayOff
    #Get Relay index/number from the user
    while 1
        print "\nEnter Relay Number ( 0 to 3): "
        relay_number = STDIN.gets.chomp
        if (('0'..'3') === relay_number)
            break
        end
    end
    #Send Command
    $serport.write(("relay off " + relay_number + "\r")
    $response = read()
end

##########################################################
#                     ADC/Analog operations              #
##########################################################

#Retrieve and print ADC status
def getADCStatus
    #Get ADC index/number from the user
    while 1
        print "Enter ADC Number ( 0 to 4): "
        adc_number = STDIN.gets.chomp
        if (('0'..'4') === adc_number)
            break
        end
    end
    #Send command
    $serport.write("adc read " + adc_number + "\r")
    sleep(1)
    
    #Read and process response from the device
    $response = read()
    return $response.split[3], adc_number
end

##########################################################
#                     GPIO operations                    #
##########################################################

#Retrieve and print GPIO status
def getGpioStatus
    #Get GPIO index/number from the user
    while 1
        print "Enter GPIO Number ( 0 to 5): "
        gpio_number = STDIN.gets.chomp
        if (('0'..'5') === gpio_number)
            break
        end
    end
    #Send "gpio read" command
    $serport.write("gpio read "+ gpio_number + "\r")
    sleep(1)

    #Read and process response from the device    
    $response = read()

    return $response.split[3], gpio_number
end    

#Set GPIO high
def gpioSet
    #Get GPIO index/number from the user
    while 1
        print "Enter GPIO Number ( 0 to 5): "
        gpio_number = STDIN.gets.chomp
        if (('0'..'5') === gpio_number)
            break
        end
    end
    #Send the command
    $serport.write("gpio set "+ gpio_number + "\r")
    $response = read()
    print("Command sent...")
end

#Set GPIO low
def gpioClear
    #Get GPIO index/number from the user
    while 1
        print "Enter GPIO Number ( 0 to 5): "
        gpio_number = STDIN.gets.chomp
        if (('0'..'5') === gpio_number)
            break
        end
    end
    #Send the command
    $serport.write("gpio clear "+ gpio_number + "\r")
    $response = read()
    print("Command sent...")
end   

##########################################################
#                   Main Application Code                #
##########################################################

#Check and parse arguments
num_args = ARGV.length
        
    if (num_args != 1) 
        puts "scriptname.rb <PORT>"
        abort("E.g.  4usbrelay.rb COM4")
    else 
        $port = ARGV[0];
    end

#Open port for communication	
$serport = Serial.new($port,9600)

#Connected to device successfully. Display menu and handle user selection.   
while 1
           
    #Display menu and retrieve user selection
    selected = getMenuSelection()
    #Empty the input buffer
    
    case selected.downcase
        when '1'
            puts getFWVersion()
        when '2'
            puts getModuleid()
        when '3'
            setModuleid()
        when '4'
            while 1
                selected=RelayStatus_Control()
                case selected.downcase
                    #Process the selected option
                    when '1'
                        status, relay_number = getRelayStatus()
                        puts "\n-----------------------"
                        print "Relay #", relay_number, " status is ", status
                        puts "\n-----------------------"
                    when '2'
                        while 1
                            selected = relaycontrol()
                            case selected.downcase
                                when '1'
                                    relayOn()
                                when '2'
                                    relayOff()
                                when '3'
                                    break
                                when 'b'
                                    break
                                when 'q'
                                    print "\nExiting..."
                                    exit(0)
                                else
                                puts "\nUnknown Option Selected! Please enter a valid option from menu below"
                            end
                        end
                        if selected.downcase == 'b'
                            break
                        end
                    when 'b'
                        break
                    when 'q'
                        print "\nExiting..."
                        exit(0)
                    else
                        puts "\nUnknown Option Selected! Please enter a valid option from menu below"
                end
            end
        when '5'
            status, adc_number = getADCStatus()
            puts "\n-----------------------"
            print "ADC #", adc_number, " status is ", status
            puts "\n-----------------------"
        when '6'
            while 1 
                selected = GPIO()
                case selected.downcase
                    when '1'
                        status, gpio_number = getGpioStatus
                        puts "\n-----------------------"
                        print "GPIO #", gpio_number, " status is ", status
                        puts "\n-----------------------"
                    when '2'
                        while 1 
                            selected = gpioControl()
                            case selected.downcase
                                when '1'
                                    gpioSet()
                                when '2'
                                    gpioClear()
                                when '3'
                                    break
                                when 'b'
                                    break
                                when 'q'
                                    print "\nExiting..."
                                    exit(0)
                                else
                                    puts "\nUnknown Option Selected! Please enter a valid option from menu below"
                            end
                        end
                        if selected.downcase == 'b'
                            break
                        end
                    when 'b'
                        break
                    when 'q'
                        print "\nExiting..."
                        exit(0)
                    else
                        puts "\nUnknown Option Selected! Please enter a valid option from menu below"
                end
            end
        when '7'
            puts "\n--------------------"
            puts reset()
            puts "--------------------"
        when 'q'
            print "\nExiting..."
            exit(0)
        else
            puts "\nUnknown Option Selected! Please enter a valid option from menu below"
    end
end


#Close the port
$serport.close()    
    