/*
## License

Copyright © 2017, Numato Systems Private Limited. All rights reserved.

This software including all supplied files, Intellectual Property, know-how
or part of thereof as applicable (collectively called SOFTWARE) in source
and/or binary form with accompanying documentation is licensed to you by
Numato Systems Private Limited (LICENSOR) subject to the following conditions.

1. This license permits perpetual use of the SOFTWARE if all conditions in this
   license are met. This license stands revoked in the event of breach of any
   of the conditions.    
2. You may use, modify, copy the SOFTWARE within your organization. This
   SOFTWARE shall not be transferred to third parties in any form except
   fully compiled binary form as part of your final application.
3. This SOFTWARE is licensed only to be used in connection with/executed on
   supported products manufactured by Numato Systems Private Limited.
   Using/executing this SOFTWARE on/in connection with custom or third party
   hardware without the LICENSOR's prior written permission is expressly
   prohibited.
4. You may not download or otherwise secure a copy of this SOFTWARE for the
   purpose of competing with Numato Systems Private Limited or subsidiaries in
   any way such as but not limited to sharing the SOFTWARE with competitors, 
   reverse engineering etc... You may not do so even if you have no gain 
   financial or otherwise from such action.
5. DISCLAIMER
5.1. USING THIS SOFTWARE IS VOLUNTARY AND OPTIONAL. NO PART OF THIS SOFTWARE
     CONSTITUTE A PRODUCT OR PART OF PRODUCT SOLD BY THE LICENSOR.
5.2. THIS SOFTWARE AND DOCUMENTATION ARE PROVIDED “AS IS” WITH ALL FAULTS,
     DEFECTS AND ERRORS AND WITHOUT WARRANTY OF ANY KIND.
5.3. THE LICENSOR DISCLAIMS ALL WARRANTIES EITHER EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY OR FITNESS FOR ANY
     PURPOSE.
5.4. IN NO EVENT, SHALL THE LICENSOR, IT’S PARTNERS OR DISTRIBUTORS BE LIABLE OR
     OBLIGATED FOR ANY DAMAGES, EXPENSES, COSTS, LOSS OF MONEY, LOSS OF TANGIBLE
     OR INTANGIBLE ASSETS DIRECT OR INDIRECT UNDER ANY LEGAL ARGUMENT SUCH AS BUT
     NOT LIMITED TO CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH
     OF WARRANTY OR ANY OTHER SIMILAR LEGAL DEFINITION.
*/


/*
Numato Lab - http://numato.com
This node.js sample script opens the port and sends two commands to the device. These commands 
will turn on Relay0, wait for 2 seconds and then turn off. The response received from the device
is printed to the console unparsed.

Please follow the steps below to test the script.

1. Download and install Node.js from https://nodejs.org/download/
2. Run command "npm install serialport" at the command prompt to install serial port library.
3. Attach the gpio device to the PC and note the port identifier corresponding to the device.
4. Update the line below that starts with "var port =" with the port name for your device.
5. Run the script by entering the command "node UsbRelay" at the command prompt
*/

var SerialPort = require("serialport").SerialPort
var port = "com5";

var portObj = new SerialPort(port,{
  baudrate: 19200
}, false);

portObj.on('data', function(data){
	console.log('Data Returned by the device');
	console.log('--------------------');
    console.log(String(data));
	console.log('--------------------');
});

portObj.open(function (error){
  if ( error ) {
		console.log('Failed to open port: ' + error);
  } else {
		console.log('Writing command gpio set 0 to port');
		portObj.write("relay on 0\r", function(err, results){
			if(error){
				console.log('Failed to write to port: '+ error);
			}
		});
		
		console.log('Waiting for two seconds');
		setTimeout(
			function(){
				console.log('Writing command gpio clear 0 to port');
				portObj.write("relay off 0\r", function(err, results){
					if(error){
						console.log('Failed to write to port: '+ error);
					}
				});
				
				setTimeout( function(){process.exit(code=0);}, 1000);
			}
		,2000);
  }
});